/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.result;

import filenet.vw.api.VWRoster;
import filenet.vw.api.VWRosterStats;
import filenet.vw.api.VWTimeUnitType;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.result.VWAdminResultPane;
import filenet.vw.toolkit.admin.result.VWAdminStatisticsTableModel;
import filenet.vw.toolkit.admin.result.resources.VWResource;
import filenet.vw.toolkit.admin.search.VWAdminPerformSearchEvent;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.util.Date;
import java.util.Vector;
import javax.swing.JOptionPane;

public class VWAdminStatsInRosterTableModel
extends VWAdminStatisticsTableModel {
    protected String[] m_rosterNames = null;

    public VWAdminStatsInRosterTableModel(VWAdminResultPane resultsPane, VWAdminPerformSearchEvent event) throws Exception {
        super(resultsPane, event);
        if (this.m_vwSession == null) {
            return;
        }
        this.m_rosterNames = event.getListOfSelectedItems();
        if (this.m_rosterNames == null || this.m_rosterNames.length == 0) {
            JOptionPane.showMessageDialog(this.m_resultsPane.getParentFrame(), VWResource.s_statisticsNoRosterSelection, VWResource.s_statistics, 0);
            return;
        }
        this.initTable();
    }

    protected void retrieveStats() throws Exception {
        VWRoster vwRoster = null;
        VWRosterStats vwRosterStats = null;
        this.m_objectCache.removeAllElements();
        for (int i = 0; i < this.m_rosterNames.length; ++i) {
            vwRoster = this.m_vwSession.getRoster(this.m_rosterNames[i]);
            if (vwRoster == null || (vwRosterStats = vwRoster.fetchStatistics(this.m_startTime, this.m_endTime, this.m_timeUnits)) == null) continue;
            this.m_objectCache.addElement(vwRosterStats);
        }
    }

    protected void buildAvailableColumnsList() {
        String[] names = null;
        try {
            this.m_availableColumns.removeAllElements();
            names = this.getDefaultColumns();
            for (int i = 0; i < names.length; ++i) {
                this.m_availableColumns.addElement(names[i]);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected Object getObjectAt(int rowIndex) {
        VWRosterStats obj = null;
        if (rowIndex > this.getRowCount() - 1) {
            return null;
        }
        obj = (VWRosterStats)this.m_objectCache.elementAt(rowIndex);
        return obj;
    }

    protected void retrieveRowData() {
        Vector<Object> rowData = null;
        String fieldName = null;
        Object fieldValue = null;
        try {
            if (this.m_rowCache != null) {
                this.m_rowCache.removeAllElements();
            }
            for (int i = 0; i < this.m_objectCache.size(); ++i) {
                VWRosterStats statsObj = (VWRosterStats)this.m_objectCache.elementAt(i);
                rowData = new Vector<Object>();
                for (int col = 0; col < this.m_headers.size(); ++col) {
                    fieldName = (String)this.m_headers.elementAt(col);
                    fieldValue = this.getFieldValue(statsObj, fieldName);
                    if (fieldValue == null) {
                        fieldValue = "";
                    } else if (VWStringUtils.compare(fieldName, VWResource.s_requestedTimeUnit) == 0) {
                        String typeName = VWTimeUnitType.getLocalizedString((Integer)fieldValue);
                        fieldValue = fieldValue + " (" + typeName + ")";
                    }
                    rowData.addElement(fieldValue);
                }
                this.m_rowCache.addElement(rowData);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void retrieveRowData(int rowIndex) {
        Vector<Object> rowData = null;
        String fieldName = null;
        Object fieldValue = null;
        try {
            VWRosterStats statsObj = (VWRosterStats)this.m_objectCache.elementAt(rowIndex);
            rowData = new Vector<Object>();
            for (int col = 0; col < this.m_headers.size(); ++col) {
                fieldName = (String)this.m_headers.elementAt(col);
                fieldValue = this.getFieldValue(statsObj, fieldName);
                if (fieldValue == null) {
                    fieldValue = "";
                } else if (VWStringUtils.compare(fieldName, VWResource.s_requestedTimeUnit) == 0) {
                    String typeName = VWTimeUnitType.getLocalizedString((Integer)fieldValue);
                    fieldValue = fieldValue + " (" + typeName + ")";
                }
                rowData.addElement(fieldValue);
            }
            this.m_rowCache.setElementAt(rowData, rowIndex);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected String[] getDefaultColumns() {
        Vector<String> columnNames = null;
        Object[] names = null;
        try {
            columnNames = new Vector<String>();
            columnNames.addElement(VWResource.s_averageLifeSpanChildWO);
            columnNames.addElement(VWResource.s_averageLifeSpanOfWO);
            columnNames.addElement(VWResource.s_averageLifeSpanParentWO);
            columnNames.addElement(VWResource.s_averageNumberOfActiveChildWO);
            columnNames.addElement(VWResource.s_averageNumberOfActiveParentWO);
            columnNames.addElement(VWResource.s_averageNumberOfActiveWO);
            columnNames.addElement(VWResource.s_childCreationRate);
            columnNames.addElement(VWResource.s_childrenGrowRate);
            columnNames.addElement(VWResource.s_childTerminationRate);
            columnNames.addElement(VWResource.s_endTime);
            columnNames.addElement(VWResource.s_evaluationTime);
            columnNames.addElement(VWResource.s_initialNumberOfWO);
            columnNames.addElement(VWResource.s_numberOfActiveChildWO);
            columnNames.addElement(VWResource.s_numberOfActiveParentWO);
            columnNames.addElement(VWResource.s_numberOfCreatedChildWO);
            columnNames.addElement(VWResource.s_numberOfCreatedParentWO);
            columnNames.addElement(VWResource.s_numberOfInitialChildWO);
            columnNames.addElement(VWResource.s_numberOfInitialParentWO);
            columnNames.addElement(VWResource.s_numberOfRemainingChildWO);
            columnNames.addElement(VWResource.s_numberOfRemainingParentWO);
            columnNames.addElement(VWResource.s_numberOfSamples);
            columnNames.addElement(VWResource.s_numberOfTerminatedChildWO);
            columnNames.addElement(VWResource.s_numberOfTerminatedParentWO);
            columnNames.addElement(VWResource.s_numberOfUnitsInPeriod);
            columnNames.addElement(VWResource.s_parentCreationRate);
            columnNames.addElement(VWResource.s_parentGrowRate);
            columnNames.addElement(VWResource.s_parentTerminationRate);
            columnNames.addElement(VWResource.s_requestedEndTime);
            columnNames.addElement(VWResource.s_requestedStartTime);
            columnNames.addElement(VWResource.s_requestedTimeUnit);
            columnNames.addElement(VWResource.s_startTime);
            columnNames.addElement(VWResource.s_summationActiveChild);
            columnNames.addElement(VWResource.s_summationActiveParent);
            columnNames.addElement(VWResource.s_summationActiveWO);
            columnNames.addElement(VWResource.s_summationChildLifeSpan);
            columnNames.addElement(VWResource.s_summationParentLifeSpan);
            columnNames.addElement(VWResource.s_summationWOLifeSpan);
            columnNames.addElement(VWResource.s_totalCreationRate);
            columnNames.addElement(VWResource.s_totalGrowRate);
            columnNames.addElement(VWResource.s_totalNumberOfActiveWO);
            columnNames.addElement(VWResource.s_totalNumberOfCreatedWO);
            columnNames.addElement(VWResource.s_totalNumberOfRemainingWO);
            columnNames.addElement(VWResource.s_totalNumberOfTerminatedWO);
            columnNames.addElement(VWResource.s_totalTerminationRate);
            names = new String[columnNames.size()];
            columnNames.copyInto(names);
            return names;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    protected Object getFieldValue(VWRosterStats obj, String colName) {
        Object fieldValue;
        block48: {
            fieldValue = null;
            try {
                if (VWStringUtils.compare(colName, VWResource.s_averageLifeSpanChildWO) == 0) {
                    fieldValue = obj.getAverageLifeSpanChildWO();
                    break block48;
                }
                if (VWStringUtils.compare(colName, VWResource.s_averageLifeSpanOfWO) == 0) {
                    fieldValue = obj.getAverageLifeSpanOfWO();
                    break block48;
                }
                if (VWStringUtils.compare(colName, VWResource.s_averageLifeSpanParentWO) == 0) {
                    fieldValue = obj.getAverageLifeSpanParentWO();
                    break block48;
                }
                if (VWStringUtils.compare(colName, VWResource.s_averageNumberOfActiveChildWO) == 0) {
                    fieldValue = obj.getAverageNumberOfActiveChildWO();
                    break block48;
                }
                if (VWStringUtils.compare(colName, VWResource.s_averageNumberOfActiveParentWO) == 0) {
                    fieldValue = obj.getAverageNumberOfActiveParentWO();
                    break block48;
                }
                if (VWStringUtils.compare(colName, VWResource.s_averageNumberOfActiveWO) == 0) {
                    fieldValue = obj.getAverageNumberOfActiveWO();
                    break block48;
                }
                if (VWStringUtils.compare(colName, VWResource.s_childCreationRate) == 0) {
                    fieldValue = obj.getChildCreationRate();
                    break block48;
                }
                if (VWStringUtils.compare(colName, VWResource.s_childrenGrowRate) == 0) {
                    fieldValue = obj.getChildrenGrowRate();
                    break block48;
                }
                if (VWStringUtils.compare(colName, VWResource.s_childTerminationRate) == 0) {
                    fieldValue = obj.getChildTerminationRate();
                    break block48;
                }
                if (VWStringUtils.compare(colName, VWResource.s_endTime) == 0) {
                    fieldValue = obj.getEndTime();
                    break block48;
                }
                if (VWStringUtils.compare(colName, VWResource.s_evaluationTime) == 0) {
                    fieldValue = obj.getEvaluationTime();
                    break block48;
                }
                if (VWStringUtils.compare(colName, VWResource.s_initialNumberOfWO) == 0) {
                    fieldValue = obj.getInitialNumberOfWO();
                    break block48;
                }
                if (VWStringUtils.compare(colName, VWResource.s_numberOfActiveChildWO) == 0) {
                    fieldValue = obj.getNumberOfActiveChildWO();
                    break block48;
                }
                if (VWStringUtils.compare(colName, VWResource.s_numberOfActiveParentWO) == 0) {
                    fieldValue = obj.getNumberOfActiveParentWO();
                    break block48;
                }
                if (VWStringUtils.compare(colName, VWResource.s_numberOfCreatedChildWO) == 0) {
                    fieldValue = obj.getNumberOfCreatedChildWO();
                    break block48;
                }
                if (VWStringUtils.compare(colName, VWResource.s_numberOfCreatedParentWO) == 0) {
                    fieldValue = obj.getNumberOfCreatedParentWO();
                    break block48;
                }
                if (VWStringUtils.compare(colName, VWResource.s_numberOfInitialChildWO) == 0) {
                    fieldValue = obj.getNumberOfInitialChildWO();
                    break block48;
                }
                if (VWStringUtils.compare(colName, VWResource.s_numberOfInitialParentWO) == 0) {
                    fieldValue = obj.getNumberOfInitialParentWO();
                    break block48;
                }
                if (VWStringUtils.compare(colName, VWResource.s_numberOfRemainingChildWO) == 0) {
                    fieldValue = obj.getNumberOfRemainingChildWO();
                    break block48;
                }
                if (VWStringUtils.compare(colName, VWResource.s_numberOfRemainingParentWO) == 0) {
                    fieldValue = obj.getNumberOfRemainingParentWO();
                    break block48;
                }
                if (VWStringUtils.compare(colName, VWResource.s_numberOfSamples) == 0) {
                    fieldValue = obj.getNumberOfSamples();
                    break block48;
                }
                if (VWStringUtils.compare(colName, VWResource.s_numberOfTerminatedChildWO) == 0) {
                    fieldValue = obj.getNumberOfTerminatedChildWO();
                    break block48;
                }
                if (VWStringUtils.compare(colName, VWResource.s_numberOfTerminatedParentWO) == 0) {
                    fieldValue = obj.getNumberOfTerminatedParentWO();
                    break block48;
                }
                if (VWStringUtils.compare(colName, VWResource.s_numberOfUnitsInPeriod) == 0) {
                    fieldValue = obj.getNumberOfUnitsInPeriod();
                    break block48;
                }
                if (VWStringUtils.compare(colName, VWResource.s_parentCreationRate) == 0) {
                    fieldValue = obj.getParentCreationRate();
                    break block48;
                }
                if (VWStringUtils.compare(colName, VWResource.s_parentGrowRate) == 0) {
                    fieldValue = obj.getParentGrowRate();
                    break block48;
                }
                if (VWStringUtils.compare(colName, VWResource.s_parentTerminationRate) == 0) {
                    fieldValue = obj.getParentTerminationRate();
                    break block48;
                }
                if (VWStringUtils.compare(colName, VWResource.s_requestedEndTime) == 0) {
                    fieldValue = obj.getRequestedEndTime();
                    break block48;
                }
                if (VWStringUtils.compare(colName, VWResource.s_requestedStartTime) == 0) {
                    fieldValue = obj.getRequestedStartTime();
                    break block48;
                }
                if (VWStringUtils.compare(colName, VWResource.s_requestedTimeUnit) == 0) {
                    fieldValue = new Integer(obj.getRequestedTimeUnit());
                    break block48;
                }
                if (VWStringUtils.compare(colName, VWResource.s_rosterName) == 0) {
                    fieldValue = obj.getRosterName();
                    break block48;
                }
                if (VWStringUtils.compare(colName, VWResource.s_startTime) == 0) {
                    fieldValue = obj.getStartTime();
                    break block48;
                }
                if (VWStringUtils.compare(colName, VWResource.s_summationActiveChild) == 0) {
                    fieldValue = obj.getSummationActiveChild();
                    break block48;
                }
                if (VWStringUtils.compare(colName, VWResource.s_summationActiveParent) == 0) {
                    fieldValue = obj.getSummationActiveParent();
                    break block48;
                }
                if (VWStringUtils.compare(colName, VWResource.s_summationActiveWO) == 0) {
                    fieldValue = obj.getSummationActiveWO();
                    break block48;
                }
                if (VWStringUtils.compare(colName, VWResource.s_summationChildLifeSpan) == 0) {
                    fieldValue = obj.getSummationChildLifeSpan();
                    break block48;
                }
                if (VWStringUtils.compare(colName, VWResource.s_summationParentLifeSpan) == 0) {
                    fieldValue = obj.getSummationParentLifeSpan();
                    break block48;
                }
                if (VWStringUtils.compare(colName, VWResource.s_summationWOLifeSpan) == 0) {
                    fieldValue = obj.getSummationWOLifeSpan();
                    break block48;
                }
                if (VWStringUtils.compare(colName, VWResource.s_totalCreationRate) == 0) {
                    fieldValue = obj.getTotalCreationRate();
                    break block48;
                }
                if (VWStringUtils.compare(colName, VWResource.s_totalGrowRate) == 0) {
                    fieldValue = obj.getTotalGrowRate();
                    break block48;
                }
                if (VWStringUtils.compare(colName, VWResource.s_totalNumberOfActiveWO) == 0) {
                    fieldValue = obj.getTotalNumberOfActiveWO();
                    break block48;
                }
                if (VWStringUtils.compare(colName, VWResource.s_totalNumberOfCreatedWO) == 0) {
                    fieldValue = obj.getTotalNumberOfCreatedWO();
                    break block48;
                }
                if (VWStringUtils.compare(colName, VWResource.s_totalNumberOfRemainingWO) == 0) {
                    fieldValue = obj.getTotalNumberOfRemainingWO();
                    break block48;
                }
                if (VWStringUtils.compare(colName, VWResource.s_totalNumberOfTerminatedWO) == 0) {
                    fieldValue = obj.getTotalNumberOfTerminatedWO();
                    break block48;
                }
                if (VWStringUtils.compare(colName, VWResource.s_totalTerminationRate) == 0) {
                    fieldValue = obj.getTotalTerminationRate();
                    break block48;
                }
                return null;
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
        if (fieldValue instanceof Date && !this.validateDate(fieldValue)) {
            fieldValue = null;
        }
        return fieldValue;
    }
}

